/*
 * @(#)DependencyFigure.java  1.0  18. Juni 2006
 *
 * Copyright (c) 2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.pert.diagram;

import ch.hslu.cm.*;
import ch.hslu.cm.pert.model.*;
import ch.hslu.cm.simulation.*;
import java.beans.*;
import java.io.IOException;
import static org.jhotdraw.draw.AttributeKeys.*;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.LineConnectionFigure;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;

/**
 * DependencyFigure.
 *
 * @author Werner Randelshofer.
 * @version 1.0 18. Juni 2006 Created.
 */
public class DependencyFigure extends LineConnectionFigure
        implements DiagramFigure, PropertyChangeListener, SimulatedObjectListener {
    private Dependency model;
    
    /** Creates a new instance. */
    public DependencyFigure() {
        setModel(new Dependency());
        STROKE_COLOR.set(this, PertDiagram.DEPENDENCY_STROKE_COLOR);
        STROKE_WIDTH.set(this, PertDiagram.DIAGRAM_STROKE_WIDTH);
        
        END_DECORATION.set(this, new ArrowTip());
        
        setAttributeEnabled(END_DECORATION, false);
        setAttributeEnabled(START_DECORATION, false);
        setAttributeEnabled(STROKE_DASHES, false);
        //  setAttributeEnabled(FONT_BOLD, false);
        setAttributeEnabled(FONT_ITALIC, false);
        setAttributeEnabled(FONT_UNDERLINE, false);
    }
    
    @Override
    public Dependency getModel() {
        return model;
    }
    public void setModel(Dependency m) {
        if (model != null) {
            model.removePropertyChangeListener(this);
            model.removeSimulatedObjectListener(this);
        }
        model = m;
        if (model != null) {
            model.addPropertyChangeListener(this);
            model.addSimulatedObjectListener(this);
        }
    }
    @Override
    public void addNotify(Drawing drawing) {
        super.addNotify(drawing);
        if ((drawing instanceof Diagram) && getModel() != null) {
            getSimulation().add(getModel());
        }
    }
    @Override
    public void removeNotify(Drawing drawing) {
        if (getDrawing() != null && getModel() != null) {
            getSimulation().remove(getModel());
        }
        super.removeNotify(drawing);
    }
    
    /**
     * Checks if two figures can be connected. Implement this method
     * to constrain the allowed connections between figures.
     */
    public boolean canConnect(Figure start, Figure end) {
        if ((start instanceof DiagramFigure)
        && (end instanceof DiagramFigure)) {
            
            DiagramFigure sf = (DiagramFigure) start;
            DiagramFigure ef = (DiagramFigure) end;
            
            return model.canConnect(
                    (SimulatedElement) sf.getModel(),
                    (SimulatedElement) ef.getModel()
                    );
        }
        
        return false;
    }
    public boolean canConnect(Figure start) {
        if (start instanceof DiagramFigure) {
            DiagramFigure sf = (DiagramFigure) start;
            SimulatedObject so = (SimulatedObject) sf.getModel();
            if (so instanceof SimulatedElement) {
                return model.canConnect((SimulatedElement) so);
            }
        }
        return false;
    }
    /**
     * Handles the disconnection of a connection.
     * Override this method to handle this event.
     */
    protected void handleDisconnect(Figure start, Figure end) {
        //System.out.println(this+".handleDisconnect");
        model.setEnd(null);
        model.setStart(null);
    }
    
    /**
     * Handles the connection of a connection.
     * Override this method to handle this event.
     */
    protected void handleConnect(Figure start, Figure end) {
        //System.out.println(this+".handleConnect");
        if ((start instanceof DiagramFigure)
        && (end instanceof DiagramFigure)) {
            DiagramFigure sf = (DiagramFigure) start;
            DiagramFigure ef = (DiagramFigure) end;
            
            model.setEnd((SimulatedElement) ef.getModel());
            model.setStart((SimulatedElement) sf.getModel());
        }
    }
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }
    
    @Override
    public void relationshipAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void relationshipRemoved(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectChanged(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectAdded(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectRemoved(SimulatedObjectEvent e) {
    }
    
    @Override
    public void objectRequestRemove(SimulatedObjectEvent e) {
        fireFigureRequestRemove();
    }
    
    @Override
    public DependencyFigure clone() {
        DependencyFigure that = (DependencyFigure) super.clone();
        that.setModel((Dependency) this.model.clone());
        
        return that;
    }
    @Override
    public void read(DOMInput in) throws IOException {
        in.openElement((in.getElementCount("model") == 1) ? "model" : "Model");
        setModel((Dependency) in.readObject(0));
        in.closeElement();
        readPoints(in);
        readAttributes(in);
    }
    @Override
    public void write(DOMOutput out) throws IOException {
        out.openElement("Model");
        out.writeObject(getModel());
        out.closeElement();
        writePoints(out);
        writeAttributes(out);
    }
    @Override
    public int getLayer() {
        return PertDiagram.DEPENDENCY_LAYER;
    }
    private Diagram getDiagram() {
        return (Diagram) getDrawing();
    }
    private Simulation getSimulation() {
        return getDiagram().getSimulation();
    }
}
